--[[ 
Inspired by Doom's mod "My House".

Instruction:
	Pick SpeedX and SpeedY just like with normal warp.
	Direction 4 or 6 is a vertical line - Height should be defined in pixels.
	Direction 2 or 8 is a horizontal line - Width should be defined in pixels.
	Also:
	* 'Always Active' flag should be set for all objects that'll appear on the screen at the teleport's destination.
	* Teleport's destination shouldn't be close to it's location.
]]

function silentTeleport(dx,dy)
    local claw = GetClaw()
    if claw.PhysicsType == 8 then -- MPFLY fix
        Teleport(dx, dy)
    else
	    claw.X = dx
		claw.Y = dy
    end
end

function main(self)
    local claw = GetClaw()

	if self.State == 0 then
		self.DrawFlags.NoDraw, self.Flags.AlwaysActive  = true, true
        if self.Width == 0 then
            self.Width = 32
        end
        if self.Height == 0 then
            self.Height = 32
        end
        self.XMin = self.X - self.Width/2
        self.YMin = self.Y - self.Height/2
        self.XMax = self.X + self.Width/2
        self.YMax = self.Y + self.Height/2
        self.timeCounter = 0
        self.State = 1
    end

	if self.State == 1 and claw:InMinMax(self) then
        local floor = math.floor
        self.destinationX = (floor(self.SpeedX/64) - floor(self.X/64))*64 + claw.X
        self.destinationY = (floor(self.SpeedY/64) - floor(self.Y/64))*64 + claw.Y
        silentTeleport(self.destinationX, self.destinationY)
        self.timeCounter = GetTime() + 25
        self.State = 2
    end

    -- Sometimes when Claw is in Jump state, the teleport fails to work on Y-axis, repeat when that happens:
    if self.State == 2 and GetTime() > self.timeCounter then
        if claw.Y > self.destinationY + 100 or claw.Y < self.destinationY - 100 then
            silentTeleport(claw.X, self.destinationY)
        end
        self.State = 1
	end
end
